﻿//////////////////////////////////////////////
// ViewportManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "Viewport.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <unordered_map>
#include <mutex>
#include <string>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ViewportManager final : public nkCommon::MaybeSingletonClass<ViewportManager>
	{
		public :

			// Getters
			Viewport* getActiveViewport () const ;

			// Setters
			void setActiveViewport (Viewport* value) ;

			// Memory manager
			Viewport* createOrRetrieve (nkMemory::StringView name) ;
			Viewport* get (nkMemory::StringView name) const ;
			Viewport* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			ViewportManager (bool isSingleton) noexcept ;
			ViewportManager (System* system) noexcept ;
			ViewportManager (const ViewportManager&) = delete ;

			// Operators
			ViewportManager& operator= (const ViewportManager&) = delete ;

		private :

			// Attributs
			std::unordered_map<std::string, nkMemory::UniquePtr<Viewport>> _memory ;
			System* _system ;
			Viewport* _activeViewport ;
			
		private :

			friend class nkCommon::MaybeSingletonClass<ViewportManager> ;
			friend class System ;
	} ;
}